/*
 * Decompiled with CFR 0.152.
 */
package fr.welloznetwork.wellozlauncher.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Locale;

public class LauncherUtil {
    private static DistributionOS distributionOS;

    public static boolean isRegisteredAccount(String username) {
        try {
            String inputLine;
            HttpURLConnection httpURLConnection = (HttpURLConnection)new URL("https://api.mojang.com/users/profiles/minecraft/" + username).openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setConnectTimeout(3000);
            httpURLConnection.setReadTimeout(3000);
            if (httpURLConnection.getResponseCode() != 200) {
                return false;
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
            StringBuilder stringBuilder = new StringBuilder();
            while ((inputLine = bufferedReader.readLine()) != null) {
                stringBuilder.append(inputLine);
            }
            bufferedReader.close();
            JsonObject jsonObject = JsonParser.parseString(stringBuilder.toString()).getAsJsonObject();
            return jsonObject.has("id") && !jsonObject.get("id").getAsString().isEmpty();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static DistributionOS getOperatingSystemType() {
        if (distributionOS == null) {
            String OS = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
            distributionOS = OS.contains("mac") || OS.contains("darwin") ? DistributionOS.MACOS : (OS.contains("win") ? DistributionOS.WINDOWS : (OS.contains("nux") ? DistributionOS.LINUX : DistributionOS.WINDOWS));
        }
        return distributionOS;
    }

    public static enum DistributionOS {
        WINDOWS,
        LINUX,
        MACOS;

    }

    public static enum Status {
        READ("Lecture du fichier JSON"),
        DL_LIBS("T\u00e9l\u00e9chargement : mc-libraries"),
        DL_ASSETS("T\u00e9l\u00e9chargement : mc-assets"),
        EXTRACT_NATIVES("T\u00e9l\u00e9chargement : mc-natives"),
        FORGE("T\u00e9l\u00e9chargement : Forge"),
        MODS("T\u00e9l\u00e9chargement : Mods"),
        EXTERNAL_FILES("T\u00e9l\u00e9chargement : Fichiers compl\u00e9mentaires"),
        POST_EXECUTIONS("Post-Initialization"),
        INTEGRATION("Mod-Initialization"),
        END("Lancement");

        private String status;

        private Status(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }
    }
}

