/*
 * Decompiled with CFR 0.152.
 */
package fr.welloznetwork.wellozlauncher.ui.frame.pages;

import fr.flowarg.flowupdater.FlowUpdater;
import fr.flowarg.flowupdater.download.DownloadList;
import fr.flowarg.flowupdater.download.IProgressCallback;
import fr.flowarg.flowupdater.download.Step;
import fr.flowarg.flowupdater.download.json.Mod;
import fr.flowarg.flowupdater.versions.ForgeVersionBuilder;
import fr.flowarg.flowupdater.versions.VanillaVersion;
import fr.flowarg.flowupdater.versions.VersionType;
import fr.theshark34.openlauncherlib.external.ExternalLaunchProfile;
import fr.theshark34.openlauncherlib.external.ExternalLauncher;
import fr.theshark34.openlauncherlib.minecraft.GameFolder;
import fr.theshark34.openlauncherlib.minecraft.GameInfos;
import fr.theshark34.openlauncherlib.minecraft.GameTweak;
import fr.theshark34.openlauncherlib.minecraft.GameType;
import fr.theshark34.openlauncherlib.minecraft.GameVersion;
import fr.theshark34.openlauncherlib.minecraft.MinecraftLauncher;
import fr.theshark34.openlauncherlib.util.Saver;
import fr.welloznetwork.wellozlauncher.WelloZLauncher;
import fr.welloznetwork.wellozlauncher.ui.PanelManager;
import fr.welloznetwork.wellozlauncher.ui.frame.Page;
import fr.welloznetwork.wellozlauncher.ui.frame.pages.PageHome;
import fr.welloznetwork.wellozlauncher.ui.frame.pages.PageSettings;
import fr.welloznetwork.wellozlauncher.util.LauncherUtil;
import java.awt.Desktop;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.List;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.text.Font;

public class PageDownload
extends Page {
    private GridPane download = new GridPane();
    private GridPane background = new GridPane();
    private Saver saver = WelloZLauncher.getInstance().getSaver();
    private Button launchButton = new Button("JOUER !");
    private Button logOutButton = new Button("Se d\u00e9connecter");
    private Button settingsButton = new Button("Param\u00e8tres");
    private Label status = new Label();
    private Label file = new Label();
    private Label copyright = new Label("Copyright WelloZNetwork. Do not distribute!");
    private Label connectedAs = new Label("Connect\u00e9 en tant que : ");
    private ProgressBar progressBar = new ProgressBar();

    @Override
    public void init(PanelManager panelManager) {
        super.init(panelManager);
        this.showDownload();
        this.showBackground();
        this.showCopyright();
        this.showProgress();
        this.showPlayButton();
        this.showConnectedAs();
        this.showLogOutButton();
        this.showSettingsButton();
        this.download.getChildren().addAll((Object[])new Node[]{this.background, this.launchButton, this.progressBar, this.status, this.file, this.logOutButton, this.settingsButton, this.copyright, this.connectedAs});
    }

    private void showDownload() {
        this.getLayout().getStyleClass().add((Object)"layout");
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setMinWidth(800.0);
        columnConstraints.setMaxWidth(0.0);
        this.getLayout().getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints, new ColumnConstraints()});
        this.getLayout().add((Node)this.download, 0, 0);
        this.progressBar.setVisible(false);
    }

    private void showBackground() {
        GridPane background = new GridPane();
        this.setCanTakeAllSize((Node)background);
        this.getLayout().add((Node)background, 1, 0);
        this.getLayout().getStyleClass().add((Object)"login");
        this.background.setMaxWidth(400.0);
        this.background.setMaxHeight(300.0);
        this.background.setTranslateX(200.0);
        this.background.setTranslateY(-20.0);
        this.background.getStyleClass().add((Object)"background");
    }

    private void showCopyright() {
        this.copyright.setFont(Font.font((String)"Montserrat Alternates Bold", (double)10.0));
        this.copyright.setTranslateX(-18.0);
        this.copyright.setTranslateY(-2.0);
        this.setCenterH((Node)this.copyright);
        this.setCanTakeAllSize((Node)this.copyright);
        this.setBottom((Node)this.copyright);
        this.setRight((Node)this.copyright);
        this.copyright.getStyleClass().add((Object)"copyright");
        this.copyright.setOnMouseClicked(e -> {
            try {
                Desktop.getDesktop().browse(new URI("https://welloznetwork.fr/"));
            }
            catch (Exception ex) {
                WelloZLauncher.getInstance().getLogger().printStackTrace(ex);
            }
        });
    }

    private void showConnectedAs() {
        this.connectedAs.setFont(Font.font((String)"Montserrat Alternates Bold", (double)18.0));
        this.connectedAs.setTranslateX(2.0);
        this.connectedAs.setTranslateY(90.0);
        this.setCenterV((Node)this.connectedAs);
        this.setCenterH((Node)this.connectedAs);
        this.setCanTakeAllSize((Node)this.connectedAs);
        this.setTop((Node)this.connectedAs);
        if (WelloZLauncher.getInstance().getAuthInfos() != null) {
            this.connectedAs.setText("Connect\u00e9 en tant que : " + WelloZLauncher.getInstance().getAuthInfos().getUsername());
        }
    }

    private void showLogOutButton() {
        this.setCanTakeAllSize((Node)this.logOutButton);
        this.setCenterV((Node)this.logOutButton);
        this.setCenterH((Node)this.logOutButton);
        this.logOutButton.setMaxWidth(120.0);
        this.logOutButton.setMaxHeight(10.0);
        this.logOutButton.setTranslateY(30.0);
        this.logOutButton.getStyleClass().add((Object)"sign-up-button");
        this.logOutButton.setOnMouseClicked(e -> {
            WelloZLauncher.getInstance().getSaver().remove("accessToken");
            WelloZLauncher.getInstance().getSaver().remove("refreshToken");
            this.panelManager.showPanel(new PageHome());
        });
    }

    private void showPlayButton() {
        this.setCanTakeAllSize((Node)this.launchButton);
        this.setCenterH((Node)this.launchButton);
        this.setCenterV((Node)this.launchButton);
        this.launchButton.setMaxWidth(370.0);
        this.launchButton.setMaxHeight(70.0);
        this.launchButton.setTranslateY(-40.0);
        this.launchButton.getStyleClass().add((Object)"login-microsoft");
        this.launchButton.setOnMouseClicked(e -> {
            this.logOutButton.setDisable(true);
            this.settingsButton.setDisable(true);
            this.launchButton.setDisable(true);
            this.progressBar.setVisible(true);
            this.startDownload();
        });
    }

    private void showSettingsButton() {
        this.settingsButton.setFont(Font.font((String)"Montserrat Alternates Regular", (double)15.0));
        this.setCenterH((Node)this.settingsButton);
        this.setCanTakeAllSize((Node)this.settingsButton);
        this.setTop((Node)this.settingsButton);
        this.setRight((Node)this.settingsButton);
        this.settingsButton.setTranslateX(-20.0);
        this.settingsButton.setTranslateY(6.0);
        this.settingsButton.getStyleClass().add((Object)"settings-button");
        this.settingsButton.setOnMouseClicked(e -> this.panelManager.showPanel(new PageSettings()));
    }

    private void showProgress() {
        this.status.setFont(Font.font((String)"Montserrat Alternates Regular", (double)15.0));
        this.file.setFont(Font.font((String)"Montserrat Alternates Regular", (double)15.0));
        this.progressBar.getStyleClass().add((Object)"progress-bar");
        this.status.getStyleClass().add((Object)"progress-status");
        this.file.getStyleClass().add((Object)"progress-status");
        this.progressBar.setTranslateY(90.0);
        this.setCenterH((Node)this.progressBar);
        this.setCanTakeAllSize((Node)this.progressBar);
        this.status.setTranslateY(40.0);
        this.setCenterH((Node)this.status);
        this.setCanTakeAllSize((Node)this.status);
        this.file.setTranslateY(65.0);
        this.setCenterH((Node)this.file);
        this.setCanTakeAllSize((Node)this.file);
    }

    private void startDownload() {
        this.download.getChildren().clear();
        this.setProgress(0.0, 0.0);
        this.download.getChildren().addAll((Object[])new Node[]{this.progressBar, this.status, this.file});
        new Thread(this::update).start();
    }

    private void launchGame(String mcVersion) {
        try {
            ExternalLaunchProfile externalLaunchProfile = MinecraftLauncher.createExternalProfile(new GameInfos("welloznetwork", true, new GameVersion(mcVersion, GameType.V1_7_10), new GameTweak[]{GameTweak.FORGE}), GameFolder.FLOW_UPDATER, WelloZLauncher.getInstance().getAuthInfos());
            externalLaunchProfile.getVmArgs().add(this.getMemoryArguments());
            ExternalLauncher externalLauncher = new ExternalLauncher(externalLaunchProfile);
            Platform.runLater(() -> this.panelManager.getPrimaryStage().hide());
            Process process = externalLauncher.launch();
            Platform.runLater(() -> {
                try {
                    process.waitFor();
                    Platform.exit();
                }
                catch (InterruptedException e) {
                    WelloZLauncher.getInstance().getLogger().printStackTrace(e);
                }
            });
        }
        catch (Exception e) {
            WelloZLauncher.getInstance().getLogger().printStackTrace(e);
        }
    }

    private void update() {
        IProgressCallback iProgressCallback = new IProgressCallback(){
            private final DecimalFormat decimalFormat = new DecimalFormat("#.#");
            private String status = "";
            private String percent = "0.0%";
            private long lastUpdate = 0L;

            @Override
            public void step(Step step) {
                Platform.runLater(() -> {
                    this.status = LauncherUtil.Status.valueOf(step.name()).getStatus();
                    PageDownload.this.setStatus(String.format("%s, (%s)", this.status, this.percent));
                });
            }

            @Override
            public void update(DownloadList.DownloadInfo downloadInfo) {
                long now = System.currentTimeMillis();
                if (now - this.lastUpdate > 100L) {
                    this.lastUpdate = now;
                    Platform.runLater(() -> {
                        this.percent = this.decimalFormat.format((double)downloadInfo.getDownloadedBytes() * 100.0 / (double)downloadInfo.getTotalToDownloadBytes()) + "%";
                        PageDownload.this.setStatus(String.format("%s, (%s)", this.status, this.percent));
                        PageDownload.this.setProgress(downloadInfo.getDownloadedBytes(), downloadInfo.getTotalToDownloadBytes());
                    });
                }
            }

            @Override
            public void onFileDownloaded(Path path) {
                Platform.runLater(() -> PageDownload.this.file.setText("..." + path.toString().replace(WelloZLauncher.getInstance().getLauncherDirectory().toFile().getAbsolutePath(), "")));
            }
        };
        try {
            try {
                List modsList = Mod.getModsFromJson("https://welloznetwork.fr/download/client/mods.json").stream().map(mod -> mod.getDownloadURL().substring(mod.getDownloadURL().lastIndexOf(47) + 1)).collect(Collectors.toList());
                Path modsDirectory = WelloZLauncher.getInstance().getLauncherDirectory().resolve("mods");
                if (Files.exists(modsDirectory, new LinkOption[0])) {
                    Files.walk(modsDirectory, new FileVisitOption[0]).filter(path -> !path.toString().endsWith(".jar") || !modsList.contains(path.getFileName().toString())).forEach(path -> {
                        try {
                            WelloZLauncher.getInstance().getLogger().info("Removed file: " + path);
                            Files.delete(path);
                        }
                        catch (Exception e) {
                            WelloZLauncher.getInstance().getLogger().printStackTrace(e);
                        }
                    });
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            WelloZLauncher.getInstance().getLogger().info("FlowUpdater initialization");
            FlowUpdater flowUpdater = new FlowUpdater.FlowUpdaterBuilder().withVanillaVersion(new VanillaVersion.VanillaVersionBuilder().withName("1.7.10").withVersionType(VersionType.FORGE).build()).withForgeVersion(new ForgeVersionBuilder(ForgeVersionBuilder.ForgeVersionType.OLD).withForgeVersion("10.13.4.1614").withMods(Mod.getModsFromJson("https://welloznetwork.fr/download/client/mods.json")).build()).withLogger(WelloZLauncher.getInstance().getLogger()).withProgressCallback(iProgressCallback).build();
            WelloZLauncher.getInstance().getLogger().info("Download starting");
            flowUpdater.update(WelloZLauncher.getInstance().getLauncherDirectory());
            WelloZLauncher.getInstance().getLogger().info("Download completed");
            this.launchGame(flowUpdater.getVanillaVersion().getName());
        }
        catch (Exception e) {
            WelloZLauncher.getInstance().getLogger().err("Erreur during updating: " + e.getMessage());
            e.printStackTrace();
            Platform.runLater(() -> this.panelManager.getPrimaryStage().show());
        }
    }

    private String getMemoryArguments() {
        int memoryValue = 1024;
        try {
            if (this.saver.get("Xmx") == null) {
                throw new NumberFormatException();
            }
            memoryValue = Integer.parseInt(this.saver.get("Xmx"));
        }
        catch (NumberFormatException e) {
            this.saver.set("Xmx", String.valueOf(memoryValue));
            this.saver.save();
            WelloZLauncher.getInstance().getLogger().printStackTrace(e);
        }
        return "-Xmx" + memoryValue + "M";
    }

    private void setStatus(String status) {
        this.status.setText(status);
    }

    private void setProgress(double current, double max) {
        this.progressBar.setProgress(current / max);
    }
}

