/*
 * Decompiled with CFR 0.152.
 */
package fr.welloznetwork.wellozlauncher;

import fr.flowarg.flowlogger.ILogger;
import fr.flowarg.flowlogger.Logger;
import fr.litarvan.openauth.microsoft.MicrosoftAuthResult;
import fr.litarvan.openauth.microsoft.MicrosoftAuthenticationException;
import fr.litarvan.openauth.microsoft.MicrosoftAuthenticator;
import fr.theshark34.openlauncherlib.minecraft.AuthInfos;
import fr.theshark34.openlauncherlib.minecraft.util.GameDirGenerator;
import fr.theshark34.openlauncherlib.util.Saver;
import fr.welloznetwork.wellozlauncher.client.discord.IDiscordRPC;
import fr.welloznetwork.wellozlauncher.client.discord.RPC;
import fr.welloznetwork.wellozlauncher.ui.PanelManager;
import fr.welloznetwork.wellozlauncher.ui.frame.pages.PageDownload;
import fr.welloznetwork.wellozlauncher.ui.frame.pages.PageHome;
import fr.welloznetwork.wellozlauncher.util.LauncherUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.text.Font;
import javafx.stage.Stage;

public class WelloZLauncher
extends Application {
    private static WelloZLauncher instance;
    private PanelManager panelManager;
    private ILogger logger;
    private Path launcherDirectory = GameDirGenerator.createGameDir("welloznetwork", true);
    private Saver saver;
    private AuthInfos authInfos = null;

    public WelloZLauncher() {
        instance = this;
        this.logger = new Logger("[WelloZLauncher]", this.launcherDirectory.resolve("launcher.log"));
        if (Files.notExists(this.launcherDirectory, new LinkOption[0])) {
            try {
                Files.createDirectory(this.launcherDirectory, new FileAttribute[0]);
            }
            catch (IOException e) {
                this.logger.err("Impossible de cr\u00e9er le r\u00e9pertoire du jeu !");
                this.logger.printStackTrace(e);
            }
        }
        this.saver = new Saver(this.launcherDirectory.resolve("launcher.properties"));
        this.saver.load();
    }

    public void start(Stage primaryStage) {
        this.loadFonts();
        this.panelManager = new PanelManager(this, primaryStage);
        this.panelManager.init();
        if (this.isLoggedIn()) {
            this.panelManager.showPanel(new PageDownload());
        } else {
            this.panelManager.showPanel(new PageHome());
        }
        RPC.init();
    }

    public boolean isLoggedIn() {
        if (this.saver.get("accessToken") != null && this.saver.get("refreshToken") != null) {
            try {
                MicrosoftAuthenticator microsoftAuthenticator = new MicrosoftAuthenticator();
                MicrosoftAuthResult microsoftAuthResult = microsoftAuthenticator.loginWithRefreshToken(this.saver.get("refreshToken"));
                this.saver.set("accessToken", microsoftAuthResult.getAccessToken());
                this.saver.set("refreshToken", microsoftAuthResult.getRefreshToken());
                this.saver.save();
                this.setAuthInfos(new AuthInfos(microsoftAuthResult.getProfile().getName(), microsoftAuthResult.getAccessToken(), microsoftAuthResult.getProfile().getId(), microsoftAuthResult.getXuid(), microsoftAuthResult.getClientId()));
                return true;
            }
            catch (MicrosoftAuthenticationException e) {
                this.saver.remove("accessToken");
                this.saver.remove("refreshToken");
                this.saver.save();
                WelloZLauncher.getInstance().getLogger().printStackTrace(e);
            }
        }
        if (this.saver.get("accessToken") != null && this.saver.get("username") != null) {
            if (LauncherUtil.isRegisteredAccount(this.saver.get("username"))) {
                this.saver.remove("accessToken");
                this.saver.remove("username");
                this.saver.save();
                return false;
            }
            this.setAuthInfos(new AuthInfos(this.saver.get("username"), this.saver.get("accessToken"), UUID.nameUUIDFromBytes(("OfflinePlayer:" + this.saver.get("username")).getBytes()).toString()));
            return true;
        }
        return false;
    }

    private void loadFonts() {
        Font montserratRegular = Font.loadFont((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/assets/Montserrat-Regular.ttf"), (double)0.0);
        Font montserratBold = Font.loadFont((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/assets/Montserrat-Bold.ttf"), (double)0.0);
    }

    public void stop() {
        IDiscordRPC.INSTANCE.Discord_Shutdown();
        Platform.exit();
        System.exit(0);
    }

    public ILogger getLogger() {
        return this.logger;
    }

    public static WelloZLauncher getInstance() {
        return instance;
    }

    public Saver getSaver() {
        return this.saver;
    }

    public void setAuthInfos(AuthInfos authInfos) {
        this.authInfos = authInfos;
    }

    public AuthInfos getAuthInfos() {
        return this.authInfos;
    }

    public Path getLauncherDirectory() {
        return this.launcherDirectory;
    }
}

