/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.openlauncherlib.util.explorer;

import fr.flowarg.openlauncherlib.ModifiedByFlow;
import fr.theshark34.openlauncherlib.FailException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@ModifiedByFlow
public class FilesUtil {
    public static List<Path> listRecursive(Path directory) {
        ArrayList<Path> files = new ArrayList<Path>();
        List<Path> fs = FilesUtil.list(directory);
        for (Path f : fs) {
            if (Files.isDirectory(f, new LinkOption[0])) {
                files.addAll(FilesUtil.listRecursive(f));
            }
            files.add(f);
        }
        return files;
    }

    public static Path get(Path root, String file) {
        Path f = root.resolve(file);
        if (Files.notExists(f, new LinkOption[0])) {
            throw new FailException("Given file/directory doesn't exist !");
        }
        return f;
    }

    public static Path dir(Path d) {
        if (!Files.isDirectory(d, new LinkOption[0])) {
            throw new FailException("Given directory is not one !");
        }
        return d;
    }

    public static Path dir(Path root, String dir) {
        return FilesUtil.dir(FilesUtil.get(root, dir));
    }

    public static List<Path> list(Path dir) {
        ArrayList<Path> result = new ArrayList<Path>();
        try {
            if (Files.exists(dir, new LinkOption[0])) {
                try (Stream<Path> stream = Files.list(dir);){
                    result.addAll(stream.collect(Collectors.toList()));
                }
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FailException(e.getMessage());
        }
    }
}

