/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.openlauncherlib.minecraft;

import fr.flowarg.openlauncherlib.ModifiedByFlow;
import fr.theshark34.openlauncherlib.LaunchException;
import fr.theshark34.openlauncherlib.external.ClasspathConstructor;
import fr.theshark34.openlauncherlib.external.ExternalLaunchProfile;
import fr.theshark34.openlauncherlib.minecraft.AuthInfos;
import fr.theshark34.openlauncherlib.minecraft.FolderException;
import fr.theshark34.openlauncherlib.minecraft.GameFolder;
import fr.theshark34.openlauncherlib.minecraft.GameInfos;
import fr.theshark34.openlauncherlib.minecraft.GameTweak;
import fr.theshark34.openlauncherlib.minecraft.GameType;
import fr.theshark34.openlauncherlib.util.LogUtil;
import fr.theshark34.openlauncherlib.util.explorer.Explorer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

@ModifiedByFlow
public class MinecraftLauncher {
    public static ExternalLaunchProfile createExternalProfile(GameInfos infos, GameFolder folder, AuthInfos authInfos) throws LaunchException {
        LogUtil.info("mc-ext", infos.getGameVersion().getName());
        LogUtil.info("mc-check", infos.getGameDir().toString());
        if (authInfos == null) {
            throw new IllegalArgumentException("authInfos == null");
        }
        MinecraftLauncher.checkFolder(folder, infos.getGameDir());
        LogUtil.info("mc-cp");
        ClasspathConstructor constructor = new ClasspathConstructor();
        List<Path> libs = Explorer.dir(infos.getGameDir()).sub(folder.getLibsFolder()).allRecursive().files().match("^(.*\\.((jar)$))*$").get();
        ArrayList toRemove = new ArrayList();
        libs.forEach(f -> {
            String fileName = f.getFileName().toString();
            if (infos.getGameVersion().getGameType().equals(GameType.V1_13_HIGHER_FORGE)) {
                if (fileName.contains("asm")) {
                    if (fileName.contains("6") && !infos.getGameVersion().getName().contains("1.14")) {
                        toRemove.add(f);
                    }
                } else if (fileName.contains("guava") && (fileName.contains("20") || fileName.contains("25"))) {
                    toRemove.add(f);
                }
            } else if (infos.getGameVersion().getGameType().equals(GameType.V1_7_10) && infos.getGameTweaks().length > 0 && infos.getGameTweaks()[0] == GameTweak.FORGE) {
                if (!fileName.contains("guava")) {
                    return;
                }
                if (fileName.contains("15")) {
                    toRemove.add(f);
                }
            }
        });
        toRemove.forEach(libs::remove);
        constructor.add(libs);
        constructor.add(Explorer.dir(infos.getGameDir()).get(folder.getMainJar()));
        String mainClass = infos.getGameTweaks() == null || infos.getGameTweaks().length == 0 ? infos.getGameVersion().getGameType().getMainClass(infos) : "net.minecraft.launchwrapper.Launch";
        String classpath = constructor.make();
        List<String> args2 = infos.getGameVersion().getGameType().getLaunchArgs(infos, folder, authInfos);
        ArrayList<String> vmArgs = new ArrayList<String>();
        String nativesFolder = folder.getNativesFolder();
        vmArgs.add("-Djava.library.path=" + (nativesFolder.equals(".") ? "." : Explorer.dir(infos.getGameDir()).sub(nativesFolder).get().toString()));
        if (infos.getGameVersion().getGameType() != GameType.FABRIC) {
            vmArgs.add("-Dfml.ignoreInvalidMinecraftCertificates=true");
            vmArgs.add("-Dfml.ignorePatchDiscrepancies=true");
        }
        if (infos.getGameTweaks() != null) {
            for (GameTweak tweak : infos.getGameTweaks()) {
                args2.add("--tweakClass");
                args2.add(tweak.getTweakClass(infos));
            }
        }
        ExternalLaunchProfile profile = new ExternalLaunchProfile(mainClass, classpath, vmArgs, args2, true, infos.getServerName(), infos.getGameDir());
        LogUtil.info("done");
        return profile;
    }

    @ModifiedByFlow
    public static void checkFolder(GameFolder folder, Path directory) throws FolderException {
        Path assetsFolder = directory.resolve(folder.getAssetsFolder());
        Path libsFolder = directory.resolve(folder.getLibsFolder());
        Path nativesFolder = directory.resolve(folder.getNativesFolder());
        Path minecraftJar = directory.resolve(folder.getMainJar());
        try {
            if (Files.notExists(assetsFolder, new LinkOption[0]) || MinecraftLauncher.notEmpty(assetsFolder)) {
                throw new FolderException("Missing/Empty assets folder (" + assetsFolder + ")");
            }
            if (Files.notExists(libsFolder, new LinkOption[0]) || MinecraftLauncher.notEmpty(libsFolder)) {
                throw new FolderException("Missing/Empty libraries folder (" + libsFolder + ")");
            }
            if (Files.notExists(nativesFolder, new LinkOption[0]) || MinecraftLauncher.notEmpty(nativesFolder)) {
                throw new FolderException("Missing/Empty natives folder (" + nativesFolder + ")");
            }
            if (Files.notExists(minecraftJar, new LinkOption[0])) {
                throw new FolderException("Missing main jar (" + minecraftJar + ")");
            }
        }
        catch (IOException e) {
            throw new FolderException(e);
        }
    }

    @ModifiedByFlow
    private static boolean notEmpty(Path path) throws IOException {
        try (Stream<Path> children = Files.list(path);){
            boolean bl = children == null || !children.findAny().isPresent();
            return bl;
        }
    }
}

