/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.openlauncherlib.configuration.core;

import fr.flowarg.openlauncherlib.ModifiedByFlow;
import fr.theshark34.openlauncherlib.configuration.api.Configuration;
import fr.theshark34.openlauncherlib.configuration.api.json.JSONReader;
import fr.theshark34.openlauncherlib.configuration.api.json.JSONWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

@ModifiedByFlow
public class SimpleConfiguration
implements Configuration {
    private final Logger logger;
    private final Path file;
    private JSONObject object;

    SimpleConfiguration(Logger logger, String path) throws IOException {
        this(logger, Paths.get(path, new String[0]));
    }

    private SimpleConfiguration(Logger logger, Path file) throws IOException {
        this.file = file;
        this.logger = logger;
        this.object = Files.exists(this.file, new LinkOption[0]) ? new JSONReader(logger, file).toJSONObject() : new JSONObject();
    }

    public SimpleConfiguration(Logger logger, BufferedReader reader) throws IOException {
        this.file = null;
        this.logger = logger;
        this.object = new JSONReader(logger, reader).toJSONObject();
    }

    public SimpleConfiguration(Logger logger, JSONObject object) {
        this.object = object;
        this.file = null;
        this.logger = logger;
    }

    @Override
    public boolean has(String ... nodes) {
        if (nodes.length == 0) {
            return true;
        }
        JSONObject object = this.object;
        for (int x = 0; x < nodes.length - 1; ++x) {
            if (!object.has(nodes[x])) {
                return false;
            }
            Object o = object.get(nodes[x]);
            if (!(o instanceof JSONObject)) {
                return false;
            }
            object = (JSONObject)o;
        }
        return object.has(nodes[nodes.length - 1]);
    }

    @Override
    public <T> T get(T def, String ... nodes) {
        if (nodes.length == 0) {
            return (T)(def instanceof JSONObject ? this.object : def);
        }
        JSONObject object = this.object;
        for (int i = 0; i < nodes.length - 1; ++i) {
            if (!object.has(nodes[i])) {
                return def;
            }
            Object o = object.get(nodes[i]);
            if (!(o instanceof JSONObject)) {
                return def;
            }
            object = (JSONObject)o;
        }
        return (T)(object.has(nodes[nodes.length - 1]) ? object.get(nodes[nodes.length - 1]) : def);
    }

    @Override
    public <T> T getOrSet(T def, String ... nodes) {
        return this.getOrSet(def, false, nodes);
    }

    @Override
    public <T> T getOrSet(T def, boolean save, String ... nodes) {
        if (!this.has(nodes)) {
            this.set(def, save, nodes);
        }
        return this.get(def, nodes);
    }

    @Override
    public void set(Object value, String ... nodes) {
        this.set(value, true, nodes);
    }

    @Override
    public void set(Object value, boolean save, String ... nodes) {
        if (nodes.length == 0) {
            if (value == null) {
                this.object = new JSONObject();
                if (save) {
                    try {
                        this.save();
                    }
                    catch (IOException e) {
                        this.logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
                return;
            }
            if (!(value instanceof JSONObject)) {
                throw new IllegalArgumentException("Cannot set " + value.getClass().getSimpleName() + " to the root of config.");
            }
            this.object = (JSONObject)value;
            if (save) {
                try {
                    this.save();
                }
                catch (IOException e) {
                    this.logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            return;
        }
        Object object = this.object;
        for (int i = 0; i < nodes.length - 1; ++i) {
            Object o;
            if (((JSONObject)object).has(nodes[i]) && (o = ((JSONObject)object).get(nodes[i])) instanceof JSONObject) {
                object = (JSONObject)o;
                continue;
            }
            o = new JSONObject();
            ((JSONObject)object).put(nodes[i], o);
            object = o;
        }
        if (value == null) {
            ((JSONObject)object).remove(nodes[nodes.length - 1]);
        } else {
            ((JSONObject)object).put(nodes[nodes.length - 1], value);
        }
        if (save) {
            try {
                this.save();
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    @Override
    public void save() throws IOException {
        if (this.file == null) {
            return;
        }
        try (JSONWriter writer = new JSONWriter(this.file);){
            writer.write(this.object);
            writer.flush();
        }
    }
}

