/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowupdater.versions;

import fr.flowarg.flowio.FileUtils;
import fr.flowarg.flowupdater.download.json.CurseFileInfo;
import fr.flowarg.flowupdater.download.json.CurseModPackInfo;
import fr.flowarg.flowupdater.download.json.Mod;
import fr.flowarg.flowupdater.download.json.OptiFineInfo;
import fr.flowarg.flowupdater.utils.ModFileDeleter;
import fr.flowarg.flowupdater.versions.AbstractForgeVersion;
import fr.flowarg.flowupdater.versions.IModLoaderVersion;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OldForgeVersion
extends AbstractForgeVersion {
    OldForgeVersion(String forgeVersion, List<Mod> mods, List<CurseFileInfo> curseMods, ModFileDeleter fileDeleter, OptiFineInfo optiFine, CurseModPackInfo modPack) {
        super(mods, curseMods, forgeVersion, fileDeleter, optiFine, modPack, true);
    }

    @Override
    public void install(Path dirToInstall) throws Exception {
        super.install(dirToInstall);
        if (!this.installForge(dirToInstall, true)) {
            try {
                this.installerUrl = new URL(String.format("https://files.minecraftforge.net/maven/net/minecraftforge/forge/%s-%s/forge-%s-%s-installer.jar", this.forgeVersion, this.vanilla.getName(), this.forgeVersion, this.vanilla.getName()));
                if (!this.installForge(dirToInstall, false)) {
                    this.logger.err("Check the given forge version !");
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean checkModLoaderEnv(@NotNull Path dirToInstall) throws Exception {
        if (super.checkModLoaderEnv(dirToInstall)) {
            FileUtils.deleteDirectory(dirToInstall.resolve("libraries").resolve("net").resolve("minecraft"));
            FileUtils.deleteDirectory(dirToInstall.resolve("libraries").resolve("net").resolve("minecraftforge"));
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean installForge(Path dirToInstall, boolean first) throws Exception {
        try (BufferedInputStream stream = new BufferedInputStream(this.installerUrl.openStream());){
            IModLoaderVersion.ModLoaderLauncherEnvironment forgeLauncherEnvironment = this.prepareModLoaderLauncher(dirToInstall, stream);
            ProcessBuilder processBuilder = new ProcessBuilder(forgeLauncherEnvironment.getCommand());
            processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
            processBuilder.directory(dirToInstall.toFile());
            Process process = processBuilder.start();
            process.waitFor();
            this.logger.info("Successfully installed Forge!");
            FileUtils.deleteDirectory(forgeLauncherEnvironment.getTempDir());
            boolean bl = true;
            return bl;
        }
        catch (IOException | InterruptedException e) {
            if (first) return false;
            this.logger.printStackTrace(e);
            return false;
        }
    }

    @Override
    protected void cleanInstaller(@NotNull Path tempInstallerDir) throws Exception {
        FileUtils.deleteDirectory(tempInstallerDir.resolve("net"));
        FileUtils.deleteDirectory(tempInstallerDir.resolve("com"));
        FileUtils.deleteDirectory(tempInstallerDir.resolve("joptsimple"));
        FileUtils.deleteDirectory(tempInstallerDir.resolve("META-INF"));
        Files.deleteIfExists(tempInstallerDir.resolve("big_logo.png"));
        Files.deleteIfExists(tempInstallerDir.resolve("url.png"));
    }
}

