/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowupdater.versions;

import fr.flowarg.flowio.FileUtils;
import fr.flowarg.flowupdater.download.json.CurseFileInfo;
import fr.flowarg.flowupdater.download.json.CurseModPackInfo;
import fr.flowarg.flowupdater.download.json.Mod;
import fr.flowarg.flowupdater.download.json.OptiFineInfo;
import fr.flowarg.flowupdater.utils.ModFileDeleter;
import fr.flowarg.flowupdater.versions.AbstractForgeVersion;
import fr.flowarg.flowupdater.versions.IModLoaderVersion;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NewForgeVersion
extends AbstractForgeVersion {
    private final String[] compatibleVersions = new String[]{"1.19", "1.18", "1.17", "1.16", "1.15", "1.14", "1.13", "1.12.2-14.23.5.285", "1.12.2-14.23.5.286"};

    NewForgeVersion(String forgeVersion, List<Mod> mods, List<CurseFileInfo> curseMods, ModFileDeleter fileDeleter, OptiFineInfo optiFine, CurseModPackInfo modPack) {
        super(mods, curseMods, forgeVersion, fileDeleter, optiFine, modPack, false);
    }

    @Override
    public void install(Path dirToInstall) throws Exception {
        super.install(dirToInstall);
        if (!this.isCompatible()) {
            return;
        }
        try (BufferedInputStream stream = new BufferedInputStream(this.installerUrl.openStream());){
            IModLoaderVersion.ModLoaderLauncherEnvironment forgeLauncherEnvironment = this.prepareModLoaderLauncher(dirToInstall, stream);
            ProcessBuilder processBuilder = new ProcessBuilder(forgeLauncherEnvironment.getCommand());
            processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
            Process process = processBuilder.start();
            process.waitFor();
            this.logger.info("Successfully installed Forge!");
            FileUtils.deleteDirectory(forgeLauncherEnvironment.getTempDir());
        }
        catch (IOException | InterruptedException e) {
            this.logger.printStackTrace(e);
        }
    }

    @Override
    public boolean checkModLoaderEnv(@NotNull Path dirToInstall) throws Exception {
        if (this.isCompatible() && super.checkModLoaderEnv(dirToInstall)) {
            FileUtils.deleteDirectory(dirToInstall.resolve("libraries").resolve("net").resolve("minecraft"));
            FileUtils.deleteDirectory(dirToInstall.resolve("libraries").resolve("net").resolve("minecraftforge"));
            FileUtils.deleteDirectory(dirToInstall.resolve("libraries").resolve("de").resolve("oceanlabs"));
            FileUtils.deleteDirectory(dirToInstall.resolve("libraries").resolve("cpw"));
        }
        return false;
    }

    private boolean isCompatible() {
        for (String str : this.compatibleVersions) {
            if (!this.forgeVersion.startsWith(str)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void cleanInstaller(@NotNull Path tempInstallerDir) throws Exception {
        FileUtils.deleteDirectory(tempInstallerDir.resolve("net"));
        FileUtils.deleteDirectory(tempInstallerDir.resolve("com"));
        FileUtils.deleteDirectory(tempInstallerDir.resolve("joptsimple"));
        Files.deleteIfExists(tempInstallerDir.resolve("META-INF").resolve("MANIFEST.MF"));
        Files.deleteIfExists(tempInstallerDir.resolve("lekeystore.jks"));
        Files.deleteIfExists(tempInstallerDir.resolve("big_logo.png"));
        Files.deleteIfExists(tempInstallerDir.resolve("META-INF").resolve("FORGE.DSA"));
        Files.deleteIfExists(tempInstallerDir.resolve("META-INF").resolve("FORGE.SF"));
    }
}

