/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowupdater.versions;

import fr.flowarg.flowlogger.ILogger;
import fr.flowarg.flowupdater.FlowUpdater;
import fr.flowarg.flowupdater.download.DownloadList;
import fr.flowarg.flowupdater.download.IProgressCallback;
import fr.flowarg.flowupdater.download.json.Mod;
import fr.flowarg.flowupdater.utils.IOUtils;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;

public interface IModLoaderVersion {
    public void attachFlowUpdater(FlowUpdater var1);

    public boolean isModLoaderAlreadyInstalled(Path var1);

    public void install(Path var1) throws Exception;

    public ModLoaderLauncherEnvironment prepareModLoaderLauncher(Path var1, InputStream var2) throws Exception;

    public void installMods(Path var1) throws Exception;

    public List<Mod> getMods();

    default public void installAllMods(Path modsDir) {
        this.getDownloadList().getMods().forEach(mod -> {
            try {
                Path modFilePath = modsDir.resolve(mod.getName());
                IOUtils.download(this.getLogger(), new URL(mod.getDownloadURL()), modFilePath);
                this.getCallback().onFileDownloaded(modFilePath);
            }
            catch (Exception e) {
                this.getLogger().printStackTrace(e);
            }
            this.getDownloadList().incrementDownloaded(mod.getSize());
            this.getCallback().update(this.getDownloadList().getDownloadInfo());
        });
        this.getDownloadList().getCurseMods().forEach(curseMod -> {
            try {
                Path modFilePath = modsDir.resolve(curseMod.getName());
                IOUtils.download(this.getLogger(), new URL(curseMod.getDownloadURL()), modFilePath);
                this.getCallback().onFileDownloaded(modFilePath);
            }
            catch (Exception e) {
                this.getLogger().printStackTrace(e);
            }
            this.getDownloadList().incrementDownloaded(curseMod.getLength());
            this.getCallback().update(this.getDownloadList().getDownloadInfo());
        });
    }

    public boolean checkModLoaderEnv(Path var1) throws Exception;

    public DownloadList getDownloadList();

    public ILogger getLogger();

    public IProgressCallback getCallback();

    public static class ModLoaderLauncherEnvironment {
        private final List<String> command;
        private final Path tempDir;

        public ModLoaderLauncherEnvironment(List<String> command, Path tempDir) {
            this.command = command;
            this.tempDir = tempDir;
        }

        public List<String> getCommand() {
            return this.command;
        }

        public Path getTempDir() {
            return this.tempDir;
        }
    }
}

