/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowupdater.versions;

import fr.flowarg.flowupdater.download.json.CurseFileInfo;
import fr.flowarg.flowupdater.download.json.CurseModPackInfo;
import fr.flowarg.flowupdater.download.json.Mod;
import fr.flowarg.flowupdater.download.json.OptiFineInfo;
import fr.flowarg.flowupdater.utils.ModFileDeleter;
import fr.flowarg.flowupdater.utils.builderapi.BuilderArgument;
import fr.flowarg.flowupdater.utils.builderapi.BuilderException;
import fr.flowarg.flowupdater.utils.builderapi.IBuilder;
import fr.flowarg.flowupdater.versions.AbstractForgeVersion;
import fr.flowarg.flowupdater.versions.NewForgeVersion;
import fr.flowarg.flowupdater.versions.OldForgeVersion;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;

public class ForgeVersionBuilder
implements IBuilder<AbstractForgeVersion> {
    private final ForgeVersionType type;
    private final BuilderArgument<String> forgeVersionArgument = new BuilderArgument("ForgeVersion").required();
    private final BuilderArgument<OptiFineInfo> optiFineArgument = new BuilderArgument("OptiFine").optional();
    private final BuilderArgument<List<Mod>> modsArgument = new BuilderArgument<List>("Mods", ArrayList::new).optional();
    private final BuilderArgument<List<CurseFileInfo>> curseModsArgument = new BuilderArgument<List>("CurseMods", ArrayList::new).optional();
    private final BuilderArgument<ModFileDeleter> fileDeleterArgument = new BuilderArgument<ModFileDeleter>("ModFileDeleter", () -> new ModFileDeleter(false, new String[0])).optional();
    private final BuilderArgument<CurseModPackInfo> modPackArgument = new BuilderArgument("ModPack").optional();

    public ForgeVersionBuilder(ForgeVersionType type) {
        this.type = type;
    }

    public ForgeVersionBuilder withForgeVersion(String forgeVersion) {
        this.forgeVersionArgument.set(forgeVersion);
        return this;
    }

    public ForgeVersionBuilder withMods(List<Mod> mods) {
        this.modsArgument.set(mods);
        return this;
    }

    public ForgeVersionBuilder withCurseMods(List<CurseFileInfo> curseMods) {
        this.curseModsArgument.set(curseMods);
        return this;
    }

    public ForgeVersionBuilder withCurseModPack(CurseModPackInfo modPackInfo) {
        this.modPackArgument.set(modPackInfo);
        return this;
    }

    public ForgeVersionBuilder withFileDeleter(ModFileDeleter fileDeleter) {
        this.fileDeleterArgument.set(fileDeleter);
        return this;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.6.0")
    public ForgeVersionBuilder withModPack(CurseModPackInfo modPackInfo) {
        this.modPackArgument.set(modPackInfo);
        return this;
    }

    public ForgeVersionBuilder withOptiFine(OptiFineInfo optiFineInfo) {
        this.optiFineArgument.set(optiFineInfo);
        return this;
    }

    @Override
    public AbstractForgeVersion build() throws BuilderException {
        switch (this.type) {
            case NEW: {
                return new NewForgeVersion(this.forgeVersionArgument.get(), this.modsArgument.get(), this.curseModsArgument.get(), this.fileDeleterArgument.get(), this.optiFineArgument.get(), this.modPackArgument.get());
            }
            case OLD: {
                return new OldForgeVersion(this.forgeVersionArgument.get(), this.modsArgument.get(), this.curseModsArgument.get(), this.fileDeleterArgument.get(), this.optiFineArgument.get(), this.modPackArgument.get());
            }
        }
        return null;
    }

    public static enum ForgeVersionType {
        NEW,
        OLD;

    }
}

