/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowupdater.versions;

import fr.flowarg.flowio.FileUtils;
import fr.flowarg.flowlogger.ILogger;
import fr.flowarg.flowupdater.FlowUpdater;
import fr.flowarg.flowupdater.download.DownloadList;
import fr.flowarg.flowupdater.download.ICurseFeaturesUser;
import fr.flowarg.flowupdater.download.IProgressCallback;
import fr.flowarg.flowupdater.download.Step;
import fr.flowarg.flowupdater.download.json.CurseFileInfo;
import fr.flowarg.flowupdater.download.json.CurseModPackInfo;
import fr.flowarg.flowupdater.download.json.Mod;
import fr.flowarg.flowupdater.download.json.OptiFineInfo;
import fr.flowarg.flowupdater.integrations.curseforgeintegration.CurseMod;
import fr.flowarg.flowupdater.integrations.optifineintegration.OptiFine;
import fr.flowarg.flowupdater.utils.IOUtils;
import fr.flowarg.flowupdater.utils.ModFileDeleter;
import fr.flowarg.flowupdater.versions.IModLoaderVersion;
import fr.flowarg.flowupdater.versions.VanillaVersion;
import fr.flowarg.flowzipper.ZipUtils;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractForgeVersion
implements ICurseFeaturesUser,
IModLoaderVersion {
    protected final List<Mod> mods;
    protected final List<CurseFileInfo> curseMods;
    protected final ModFileDeleter fileDeleter;
    protected final OptiFineInfo optiFineInfo;
    protected final CurseModPackInfo modPackInfo;
    protected final boolean old;
    protected List<CurseMod> allCurseMods;
    protected URL installerUrl;
    protected DownloadList downloadList;
    protected ILogger logger;
    protected IProgressCallback callback;
    protected VanillaVersion vanilla;
    protected String forgeVersion;

    protected AbstractForgeVersion(List<Mod> mods, List<CurseFileInfo> curseMods, String forgeVersion, ModFileDeleter fileDeleter, OptiFineInfo optiFineInfo, CurseModPackInfo modPackInfo, boolean old) {
        this.mods = mods;
        this.curseMods = curseMods;
        this.forgeVersion = forgeVersion;
        this.fileDeleter = fileDeleter;
        this.optiFineInfo = optiFineInfo;
        this.modPackInfo = modPackInfo;
        this.old = old;
    }

    @Override
    public boolean isModLoaderAlreadyInstalled(@NotNull Path installDir) {
        Path forgeDir = installDir.resolve("libraries").resolve("net").resolve("minecraftforge").resolve("forge").resolve(this.forgeVersion);
        if (Files.notExists(forgeDir, new LinkOption[0])) {
            return false;
        }
        return Files.exists(forgeDir.resolve("forge-" + this.forgeVersion + ".jar"), new LinkOption[0]) || Files.exists(forgeDir.resolve("forge-" + this.forgeVersion + "-universal.jar"), new LinkOption[0]);
    }

    @Override
    public void install(Path dirToInstall) throws Exception {
        this.callback.step(Step.FORGE);
        this.logger.info("Installing forge, version: " + this.forgeVersion + "...");
        this.checkModLoaderEnv(dirToInstall);
    }

    @Override
    public IModLoaderVersion.ModLoaderLauncherEnvironment prepareModLoaderLauncher(@NotNull Path dirToInstall, InputStream stream) throws Exception {
        Path tempDirPath = dirToInstall.resolve(".flowupdater");
        FileUtils.deleteDirectory(tempDirPath);
        Files.createDirectories(tempDirPath, new FileAttribute[0]);
        Path installPath = tempDirPath.resolve("forge-installer.jar");
        Path patchesPath = tempDirPath.resolve("patches.jar");
        this.downloadForgeInstaller(stream, installPath, patchesPath);
        this.patchForgeInstaller(installPath, patchesPath, tempDirPath);
        return this.makeCommand(tempDirPath.resolve("forge-installer-patched.jar"), dirToInstall, tempDirPath);
    }

    protected void downloadForgeInstaller(InputStream stream, Path install, Path patches) throws Exception {
        this.logger.info("Downloading " + (this.old ? "old" : "new") + " forge installer...");
        Files.copy(stream, install, StandardCopyOption.REPLACE_EXISTING);
        this.logger.info("Downloading patches...");
        Files.copy(new URL("https://flowarg.github.io/minecraft/launcher/" + (this.old ? "old" : "") + "patches.jar").openStream(), patches, StandardCopyOption.REPLACE_EXISTING);
    }

    protected void patchForgeInstaller(Path install, Path patches, Path tempDir) {
        try {
            Path tempInstallerDirPath = tempDir.resolve("installer");
            Files.createDirectories(tempInstallerDirPath, new FileAttribute[0]);
            this.logger.info("Applying patches...");
            ZipUtils.unzipJar(tempInstallerDirPath, install, new String[0]);
            this.cleanInstaller(tempInstallerDirPath);
            ZipUtils.unzipJar(tempInstallerDirPath, patches, new String[0]);
            this.logger.info("Repacking installer...");
            this.packPatchedInstaller(tempDir, tempInstallerDirPath);
            Files.delete(patches);
        }
        catch (Exception e) {
            this.logger.printStackTrace(e);
        }
    }

    protected IModLoaderVersion.ModLoaderLauncherEnvironment makeCommand(@NotNull Path patchedInstaller, @NotNull Path dirToInstall, Path tempDir) {
        ArrayList<String> command = new ArrayList<String>();
        command.add("java");
        command.add("-Xmx256M");
        command.add("-jar");
        command.add(patchedInstaller.toAbsolutePath().toString());
        command.add("--installClient");
        command.add(dirToInstall.toAbsolutePath().toString());
        this.logger.info("Launching forge installer...");
        return new IModLoaderVersion.ModLoaderLauncherEnvironment(command, tempDir);
    }

    protected abstract void cleanInstaller(Path var1) throws Exception;

    @Override
    public boolean checkModLoaderEnv(@NotNull Path dirToInstall) throws Exception {
        Path forgeDirPath = dirToInstall.resolve("libraries").resolve("net").resolve("minecraftforge").resolve("forge");
        if (!Files.exists(forgeDirPath, new LinkOption[0])) {
            return false;
        }
        boolean result = false;
        for (Path contained : FileUtils.list(forgeDirPath)) {
            if (contained.getFileName().toString().contains(this.forgeVersion)) continue;
            FileUtils.deleteDirectory(contained);
            result = true;
        }
        return result;
    }

    @Override
    public void installMods(Path modsDir) throws Exception {
        this.callback.step(Step.MODS);
        this.installAllMods(modsDir);
        OptiFine ofObj = this.downloadList.getOptiFine();
        if (ofObj != null) {
            try {
                Path optiFineFilePath = modsDir.resolve(ofObj.getName());
                if (Files.notExists(optiFineFilePath, new LinkOption[0]) || Files.size(optiFineFilePath) != (long)ofObj.getSize()) {
                    IOUtils.copy(this.logger, modsDir.getParent().resolve(".op").resolve(ofObj.getName()), optiFineFilePath);
                }
            }
            catch (Exception e) {
                this.logger.printStackTrace(e);
            }
            this.downloadList.incrementDownloaded(ofObj.getSize());
            this.callback.update(this.downloadList.getDownloadInfo());
        }
        this.fileDeleter.delete(modsDir, this.mods, this.allCurseMods, ofObj);
    }

    protected void packPatchedInstaller(@NotNull Path tempDir, Path tempInstallerDir) throws Exception {
        Path outputPath = tempDir.resolve("forge-installer-patched.zip");
        ZipUtils.compressFiles(FileUtils.list(tempInstallerDir).toArray(new Path[0]), outputPath);
        Files.move(outputPath, Paths.get(outputPath.toString().replace(".zip", ".jar"), new String[0]), StandardCopyOption.REPLACE_EXISTING);
        FileUtils.deleteDirectory(tempInstallerDir);
    }

    @Override
    public List<Mod> getMods() {
        return this.mods;
    }

    @Override
    public void setAllCurseMods(List<CurseMod> allCurseMods) {
        this.allCurseMods = allCurseMods;
    }

    public ModFileDeleter getFileDeleter() {
        return this.fileDeleter;
    }

    @Override
    public void attachFlowUpdater(@NotNull FlowUpdater flowUpdater) {
        this.callback = flowUpdater.getCallback();
        this.logger = flowUpdater.getLogger();
        this.downloadList = flowUpdater.getDownloadList();
        this.vanilla = flowUpdater.getVanillaVersion();
        this.forgeVersion = !this.forgeVersion.contains("-") ? this.vanilla.getName() + '-' + this.forgeVersion : this.forgeVersion.trim();
        try {
            this.installerUrl = new URL(String.format("https://maven.minecraftforge.net/net/minecraftforge/forge/%s/forge-%s-installer.jar", this.forgeVersion, this.forgeVersion));
        }
        catch (Exception e) {
            this.logger.printStackTrace(e);
        }
    }

    @Override
    public DownloadList getDownloadList() {
        return this.downloadList;
    }

    @Override
    public IProgressCallback getCallback() {
        return this.callback;
    }

    @Override
    public List<CurseFileInfo> getCurseMods() {
        return this.curseMods;
    }

    public OptiFineInfo getOptiFineInfo() {
        return this.optiFineInfo;
    }

    @Override
    public CurseModPackInfo getModPackInfo() {
        return this.modPackInfo;
    }

    @Override
    public ILogger getLogger() {
        return this.logger;
    }

    public String getForgeVersion() {
        return this.forgeVersion;
    }

    public URL getInstallerUrl() {
        return this.installerUrl;
    }
}

