/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowupdater.utils;

import fr.flowarg.flowupdater.utils.ExternalFileDeleter;
import fr.flowarg.flowupdater.utils.builderapi.BuilderArgument;
import fr.flowarg.flowupdater.utils.builderapi.BuilderException;
import fr.flowarg.flowupdater.utils.builderapi.IBuilder;
import org.jetbrains.annotations.ApiStatus;

public class UpdaterOptions {
    public static final UpdaterOptions DEFAULT = new UpdaterOptions(true, false, new ExternalFileDeleter());
    private final boolean silentRead;
    private final boolean downloadServer;
    private final ExternalFileDeleter externalFileDeleter;

    private UpdaterOptions(boolean silentRead, boolean downloadServer, ExternalFileDeleter externalFileDeleter) {
        this.silentRead = silentRead;
        this.downloadServer = downloadServer;
        this.externalFileDeleter = externalFileDeleter;
    }

    public boolean isSilentRead() {
        return this.silentRead;
    }

    public boolean isDownloadServer() {
        return this.downloadServer;
    }

    public ExternalFileDeleter getExternalFileDeleter() {
        return this.externalFileDeleter;
    }

    public static class UpdaterOptionsBuilder
    implements IBuilder<UpdaterOptions> {
        private final BuilderArgument<Boolean> silentReadArgument = new BuilderArgument<Boolean>("SilentRead", () -> true).optional();
        private final BuilderArgument<Boolean> downloadServerArgument = new BuilderArgument<Boolean>("DownloadServer", () -> false).optional();
        private final BuilderArgument<ExternalFileDeleter> externalFileDeleterArgument = new BuilderArgument<ExternalFileDeleter>("External FileDeleter", ExternalFileDeleter::new).optional();

        public UpdaterOptionsBuilder withSilentRead(boolean silentRead) {
            this.silentReadArgument.set(silentRead);
            return this;
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="1.6.0")
        public UpdaterOptionsBuilder withDownloadServer(boolean downloadServer) {
            this.downloadServerArgument.set(downloadServer);
            return this;
        }

        public UpdaterOptionsBuilder withExternalFileDeleter(ExternalFileDeleter externalFileDeleter) {
            this.externalFileDeleterArgument.set(externalFileDeleter);
            return this;
        }

        @Override
        public UpdaterOptions build() throws BuilderException {
            return new UpdaterOptions(this.silentReadArgument.get(), this.downloadServerArgument.get(), this.externalFileDeleterArgument.get());
        }
    }
}

