/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowupdater.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParser;
import fr.flowarg.flowcompat.Platform;
import fr.flowarg.flowlogger.ILogger;
import fr.flowarg.flowupdater.FlowUpdater;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.NotNull;

public class IOUtils {
    private static Path cachedMinecraftPath = null;

    public static void download(@NotNull ILogger logger, @NotNull URL in, @NotNull Path out) {
        try {
            logger.info(String.format("Downloading %s from %s...", out.getFileName().toString(), in.toExternalForm()));
            Files.createDirectories(out.getParent(), new FileAttribute[0]);
            Files.copy(IOUtils.catchForbidden(in), out, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            logger.printStackTrace(e);
        }
    }

    public static void copy(@NotNull ILogger logger, @NotNull Path in, @NotNull Path out) {
        try {
            logger.info(String.format("Copying %s to %s...", in.toString(), out.toString()));
            Files.createDirectories(out.getParent(), new FileAttribute[0]);
            Files.copy(in, out, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            logger.printStackTrace(e);
        }
    }

    @NotNull
    public static String getContent(URL url) {
        StringBuilder sb = new StringBuilder();
        try (BufferedInputStream stream = new BufferedInputStream(IOUtils.catchForbidden(url));){
            int character;
            ReadableByteChannel rbc = Channels.newChannel(stream);
            Reader enclosedReader = Channels.newReader(rbc, StandardCharsets.UTF_8.newDecoder(), -1);
            BufferedReader reader = new BufferedReader(enclosedReader);
            while ((character = reader.read()) != -1) {
                sb.append((char)character);
            }
            reader.close();
            enclosedReader.close();
            rbc.close();
        }
        catch (IOException e) {
            FlowUpdater.DEFAULT_LOGGER.printStackTrace(e);
        }
        return sb.toString();
    }

    public static JsonElement readJson(URL jsonURL) {
        try {
            return IOUtils.readJson(IOUtils.catchForbidden(jsonURL));
        }
        catch (IOException e) {
            FlowUpdater.DEFAULT_LOGGER.printStackTrace(e);
            return JsonNull.INSTANCE;
        }
    }

    public static JsonElement readJson(InputStream inputStream2) {
        JsonElement element = JsonNull.INSTANCE;
        try (BufferedInputStream stream = new BufferedInputStream(inputStream2);){
            int character;
            ReadableByteChannel rbc = Channels.newChannel(stream);
            Reader enclosedReader = Channels.newReader(rbc, StandardCharsets.UTF_8.newDecoder(), -1);
            BufferedReader reader = new BufferedReader(enclosedReader);
            StringBuilder sb = new StringBuilder();
            while ((character = reader.read()) != -1) {
                sb.append((char)character);
            }
            element = JsonParser.parseString(sb.toString());
            reader.close();
            enclosedReader.close();
            rbc.close();
        }
        catch (IOException e) {
            FlowUpdater.DEFAULT_LOGGER.printStackTrace(e);
        }
        return element.getAsJsonObject();
    }

    public static InputStream catchForbidden(@NotNull URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.addRequestProperty("User-Agent", "Mozilla/5.0 AppleWebKit/537.36 (KHTML, like Gecko) Chrome/43.0.2357.124 Safari/537.36");
        connection.setInstanceFollowRedirects(true);
        return connection.getInputStream();
    }

    public static Path getMinecraftFolder() {
        if (cachedMinecraftPath == null) {
            cachedMinecraftPath = Paths.get(Platform.isOnWindows() ? System.getenv("APPDATA") : (Platform.isOnMac() ? System.getProperty("user.home") + "/Library/Application Support/" : System.getProperty("user.home")), ".minecraft");
        }
        return cachedMinecraftPath;
    }
}

