/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowupdater.utils;

import fr.flowarg.flowio.FileUtils;
import fr.flowarg.flowupdater.download.DownloadList;
import fr.flowarg.flowupdater.download.json.ExternalFile;
import fr.flowarg.flowupdater.utils.IFileDeleter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExternalFileDeleter
implements IFileDeleter {
    public void delete(@NotNull List<ExternalFile> externalFiles, DownloadList downloadList, Path dir) throws Exception {
        if (externalFiles.isEmpty()) {
            return;
        }
        for (ExternalFile extFile : externalFiles) {
            Path filePath = dir.resolve(extFile.getPath());
            if (Files.exists(filePath, new LinkOption[0])) {
                if (!extFile.isUpdate() || FileUtils.getSHA1(filePath).equalsIgnoreCase(extFile.getSha1())) continue;
                Files.delete(filePath);
            }
            downloadList.getExtFiles().add(extFile);
        }
    }
}

