/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowupdater.download.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import fr.flowarg.flowupdater.utils.FlowUpdaterException;
import fr.flowarg.flowupdater.utils.IOUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Mod {
    private final String name;
    private final String sha1;
    private final long size;
    private final String downloadURL;

    public Mod(String name, String sha1, long size, String downloadURL) {
        this.name = name;
        this.sha1 = sha1;
        this.size = size;
        this.downloadURL = downloadURL;
    }

    @NotNull
    public static List<Mod> getModsFromJson(URL jsonUrl) {
        ArrayList<Mod> result = new ArrayList<Mod>();
        JsonObject object = IOUtils.readJson(jsonUrl).getAsJsonObject();
        JsonArray mods = object.getAsJsonArray("mods");
        mods.forEach(modElement -> {
            JsonObject obj = modElement.getAsJsonObject();
            String name = obj.get("name").getAsString();
            String sha1 = obj.get("sha1").getAsString();
            String downloadURL = obj.get("downloadURL").getAsString();
            long size = obj.get("size").getAsLong();
            result.add(new Mod(name, sha1, size, downloadURL));
        });
        return result;
    }

    @NotNull
    public static List<Mod> getModsFromJson(String jsonUrl) {
        try {
            return Mod.getModsFromJson(new URL(jsonUrl));
        }
        catch (Exception e) {
            throw new FlowUpdaterException(e);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getSha1() {
        return this.sha1;
    }

    public long getSize() {
        return this.size;
    }

    public String getDownloadURL() {
        return this.downloadURL;
    }
}

