/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowupdater.download;

import fr.flowarg.flowio.FileUtils;
import fr.flowarg.flowlogger.ILogger;
import fr.flowarg.flowstringer.StringUtils;
import fr.flowarg.flowupdater.FlowUpdater;
import fr.flowarg.flowupdater.download.DownloadList;
import fr.flowarg.flowupdater.download.IProgressCallback;
import fr.flowarg.flowupdater.download.Step;
import fr.flowarg.flowupdater.download.json.Downloadable;
import fr.flowarg.flowupdater.utils.IOUtils;
import fr.flowarg.flowzipper.ZipUtils;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import org.jetbrains.annotations.NotNull;

public class VanillaDownloader {
    private final Path dir;
    private final ILogger logger;
    private final IProgressCallback callback;
    private final DownloadList downloadList;
    private final Path natives;
    private final Path assets;
    private final String vanillaJsonURL;

    public VanillaDownloader(Path dir, @NotNull FlowUpdater flowUpdater) throws IOException {
        this.dir = dir;
        this.logger = flowUpdater.getLogger();
        this.callback = flowUpdater.getCallback();
        this.downloadList = flowUpdater.getDownloadList();
        this.natives = this.dir.resolve("natives");
        this.assets = this.dir.resolve("assets");
        this.vanillaJsonURL = flowUpdater.getVanillaVersion().getJsonURL();
        Files.createDirectories(this.dir.resolve("libraries"), new FileAttribute[0]);
        Files.createDirectories(this.assets, new FileAttribute[0]);
        Files.createDirectories(this.natives, new FileAttribute[0]);
        this.downloadList.init();
    }

    public void download() throws Exception {
        this.downloadLibraries();
        this.downloadAssets();
        this.extractNatives();
        this.logger.info("All vanilla files were successfully downloaded!");
    }

    private void downloadLibraries() throws Exception {
        this.logger.info("Checking library files...");
        this.callback.step(Step.DL_LIBS);
        Path vanillaJsonTarget = this.dir.resolve(this.vanillaJsonURL.substring(this.vanillaJsonURL.lastIndexOf(47) + 1));
        String vanillaJsonResourceName = this.vanillaJsonURL.substring(this.vanillaJsonURL.lastIndexOf(47));
        String vanillaJsonPathUrl = StringUtils.empty(this.vanillaJsonURL, "https://launchermeta.mojang.com/v1/packages/");
        if (Files.notExists(vanillaJsonTarget, new LinkOption[0]) || !FileUtils.getSHA1(vanillaJsonTarget).equals(StringUtils.empty(vanillaJsonPathUrl, vanillaJsonResourceName))) {
            IOUtils.download(this.logger, new URL(this.vanillaJsonURL), vanillaJsonTarget);
        }
        for (Downloadable downloadable : this.downloadList.getDownloadableFiles()) {
            Path filePath = this.dir.resolve(downloadable.getName());
            if (Files.notExists(filePath, new LinkOption[0]) || !FileUtils.getSHA1(filePath).equalsIgnoreCase(downloadable.getSha1()) || FileUtils.getFileSizeBytes(filePath) != downloadable.getSize()) {
                IOUtils.download(this.logger, new URL(downloadable.getUrl()), filePath);
                this.callback.onFileDownloaded(filePath);
            }
            this.downloadList.incrementDownloaded(downloadable.getSize());
            this.callback.update(this.downloadList.getDownloadInfo());
        }
    }

    private void extractNatives() throws IOException {
        Stream natives;
        boolean flag = false;
        List existingNatives = Files.list(this.natives).collect(Collectors.toList());
        if (!existingNatives.isEmpty()) {
            for (Path minecraftNative : Files.list(this.natives).filter(path -> path.getFileName().toString().endsWith(".jar")).collect(Collectors.toList())) {
                JarFile jarFile = new JarFile(minecraftNative.toFile());
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    Path flPath;
                    ZipEntry entry = entries.nextElement();
                    if (entry.isDirectory() || entry.getName().endsWith(".git") || entry.getName().endsWith(".sha1") || entry.getName().contains("META-INF") || Files.exists(flPath = this.natives.resolve(entry.getName()), new LinkOption[0]) && entry.getCrc() == FileUtils.getCRC32(flPath)) continue;
                    flag = true;
                    break;
                }
                jarFile.close();
                if (!flag) continue;
                break;
            }
        }
        if (flag) {
            this.logger.info("Extracting natives...");
            this.callback.step(Step.EXTRACT_NATIVES);
            natives = FileUtils.list(this.natives).stream();
            natives.filter(file -> !Files.isDirectory(file, new LinkOption[0]) && file.getFileName().toString().endsWith(".jar")).forEach(file -> {
                try {
                    ZipUtils.unzipJar(this.natives, file, "ignoreMetaInf");
                }
                catch (IOException e) {
                    this.logger.printStackTrace(e);
                }
            });
            natives.close();
        }
        natives = FileUtils.list(this.natives).stream();
        natives.forEach(path -> {
            try {
                if (path.getFileName().toString().endsWith(".git") || path.getFileName().toString().endsWith(".sha1")) {
                    Files.delete(path);
                } else if (Files.isDirectory(path, new LinkOption[0])) {
                    FileUtils.deleteDirectory(path);
                }
            }
            catch (IOException e) {
                this.logger.printStackTrace(e);
            }
        });
        natives.close();
    }

    private void downloadAssets() {
        this.logger.info("Checking assets...");
        this.callback.step(Step.DL_ASSETS);
        ExecutorService executorService = Executors.newWorkStealingPool();
        this.downloadList.getDownloadableAssets().forEach(assetDownloadable -> executorService.submit(() -> {
            try {
                Path downloadPath = this.assets.resolve(assetDownloadable.getFile());
                if (Files.notExists(downloadPath, new LinkOption[0]) || FileUtils.getFileSizeBytes(downloadPath) != assetDownloadable.getSize()) {
                    Path localAssetPath = IOUtils.getMinecraftFolder().resolve("assets").resolve(assetDownloadable.getFile());
                    if (Files.exists(localAssetPath, new LinkOption[0]) && FileUtils.getFileSizeBytes(localAssetPath) == assetDownloadable.getSize()) {
                        IOUtils.copy(this.logger, localAssetPath, downloadPath);
                    } else {
                        IOUtils.download(this.logger, new URL(assetDownloadable.getUrl()), downloadPath);
                        this.callback.onFileDownloaded(downloadPath);
                    }
                }
                this.downloadList.incrementDownloaded(assetDownloadable.getSize());
                this.callback.update(this.downloadList.getDownloadInfo());
            }
            catch (Exception e) {
                this.logger.printStackTrace(e);
            }
        }));
        try {
            executorService.shutdown();
            executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            this.logger.printStackTrace(e);
        }
    }
}

