/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowio;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.CRC32;

public final class FileUtils {
    public static String removeExtension(String fileName) {
        if (fileName == null) {
            return "";
        }
        if (!FileUtils.getFileExtension(Paths.get(fileName, new String[0])).isEmpty()) {
            return fileName.substring(0, fileName.lastIndexOf(46));
        }
        return fileName;
    }

    public static String getFileExtension(Path path) {
        String fileName = path.getFileName().toString();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? "" : fileName.substring(dotIndex + 1);
    }

    public static Path removeExtension(Path path) throws IOException {
        if (!FileUtils.getFileExtension(path).isEmpty()) {
            return Files.move(path, Paths.get(FileUtils.removeExtension(path.getFileName().toString()), new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
        return path;
    }

    public static void deleteDirectory(Path folder) throws IOException {
        if (Files.exists(folder, new LinkOption[0]) && Files.isDirectory(folder, new LinkOption[0])) {
            List<Path> files = FileUtils.list(folder);
            for (Path f : files) {
                if (Files.isDirectory(f, new LinkOption[0])) {
                    FileUtils.deleteDirectory(f);
                    continue;
                }
                Files.delete(f);
            }
            Files.delete(folder);
        }
    }

    public static void deleteExclude(Path toDelete, Path ... excludes) throws IOException {
        boolean flag = true;
        for (Path exclude : excludes) {
            if (!exclude.toString().equals(toDelete.toString())) continue;
            flag = false;
            break;
        }
        if (flag) {
            Files.deleteIfExists(toDelete);
        }
    }

    public static List<Path> listRecursive(Path directory) throws IOException {
        ArrayList<Path> files = new ArrayList<Path>();
        List<Path> fs = FileUtils.list(directory);
        for (Path f : fs) {
            if (Files.isDirectory(f, new LinkOption[0])) {
                files.addAll(FileUtils.listRecursive(f));
            }
            files.add(f);
        }
        return files;
    }

    public static void createDirectories(String location, String ... dirsToCreate) throws IOException {
        for (String s2 : dirsToCreate) {
            Path path = Paths.get(location, s2);
            if (!Files.notExists(path, new LinkOption[0])) continue;
            Files.createDirectory(path, new FileAttribute[0]);
        }
    }

    public static long getFileSizeMegaBytes(Path path) throws IOException {
        return FileUtils.getFileSizeBytes(path) / 0x100000L;
    }

    public static long getFileSizeKiloBytes(Path path) throws IOException {
        return FileUtils.getFileSizeBytes(path) / 1024L;
    }

    public static long getFileSizeBytes(Path path) throws IOException {
        return Files.size(path);
    }

    public static String getStringPathOfClass(Class<?> classToGetPath) {
        return classToGetPath.getProtectionDomain().getCodeSource().getLocation().getPath();
    }

    public static Path getPathOfClass(Class<?> classToGetPath) {
        return Paths.get(classToGetPath.getProtectionDomain().getCodeSource().getLocation().getPath(), new String[0]);
    }

    public static String hashInput(InputStream input, String method) throws NoSuchAlgorithmException, IOException {
        int read;
        MessageDigest digest = MessageDigest.getInstance(method);
        byte[] data = new byte[8192];
        while ((read = input.read(data)) != -1) {
            digest.update(data, 0, read);
        }
        byte[] bytes = digest.digest();
        StringBuilder sb = new StringBuilder();
        for (byte aByte : bytes) {
            sb.append(Integer.toString((aByte & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    /*
     * Exception decompiling
     */
    public static String getMD5(Path path) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static String getSHA1(Path path) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<Path> list(Path dir) throws IOException {
        ArrayList<Path> result = new ArrayList<Path>();
        if (Files.exists(dir, new LinkOption[0])) {
            try (Stream<Path> files = Files.list(dir);){
                result.addAll(files.collect(Collectors.toList()));
            }
        }
        return result;
    }

    public static long getCRC32(Path path) throws IOException {
        CRC32 checksum = new CRC32();
        byte[] bytes = Files.readAllBytes(path);
        checksum.update(bytes, 0, bytes.length);
        return checksum.getValue();
    }
}

