/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.curseapi.project;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.therandomlabs.curseapi.CursePreconditions;
import com.therandomlabs.curseapi.game.CurseCategory;
import com.therandomlabs.curseapi.game.CurseCategorySection;
import com.therandomlabs.curseapi.game.CurseGame;
import com.therandomlabs.curseapi.game.CurseGameVersion;
import com.therandomlabs.curseapi.project.CurseSearchSort;

public class CurseSearchQuery
implements Cloneable {
    private int gameID;
    private int categorySectionID;
    private int categoryID;
    private String gameVersion = "";
    private int pageIndex;
    private int pageSize;
    private String searchFilter = "";
    private CurseSearchSort sortingMethod = CurseSearchSort.FEATURED;

    public CurseSearchQuery clone() {
        try {
            return (CurseSearchQuery)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("gameID", this.gameID).add("categorySectionID", this.categorySectionID).add("categoryID", this.categoryID).add("gameVersion", this.gameVersion).add("pageIndex", this.pageIndex).add("pageSize", this.pageSize).add("searchFilter", this.searchFilter).add("sortingMethod", (Object)this.sortingMethod).toString();
    }

    public int gameID() {
        return this.gameID;
    }

    public CurseSearchQuery gameID(int id) {
        CursePreconditions.checkGameID(id, "id");
        this.gameID = id;
        return this;
    }

    public CurseSearchQuery game(CurseGame game) {
        Preconditions.checkNotNull(game, "game should not be null");
        return this.gameID(game.id());
    }

    public CurseSearchQuery clearGame() {
        this.gameID = 0;
        return this;
    }

    public int categorySectionID() {
        return this.categorySectionID;
    }

    public CurseSearchQuery categorySectionID(int id) {
        CursePreconditions.checkCategorySectionID(id, "id");
        this.categorySectionID = id;
        return this;
    }

    public CurseSearchQuery categorySection(CurseCategorySection section) {
        Preconditions.checkNotNull(section, "section should not be null");
        this.gameID(section.gameID());
        return this.categorySectionID(section.id());
    }

    public CurseSearchQuery clearCategorySection() {
        this.categorySectionID = 0;
        return this;
    }

    public int categoryID() {
        return this.categoryID;
    }

    public CurseSearchQuery categoryID(int id) {
        CursePreconditions.checkCategoryID(id, "id");
        this.categoryID = id;
        return this;
    }

    public CurseSearchQuery category(CurseCategory category) {
        Preconditions.checkNotNull(category, "category should not be null");
        this.gameID(category.gameID());
        this.categorySectionID(category.sectionID());
        return this.categoryID(category.id());
    }

    public CurseSearchQuery clearCategory() {
        this.categoryID = 0;
        return this;
    }

    public String gameVersionString() {
        return this.gameVersion;
    }

    public CurseSearchQuery gameVersionString(String version) {
        Preconditions.checkNotNull(version, "version should not be null");
        Preconditions.checkArgument(!version.isEmpty(), "version should not be empty");
        this.gameVersion = version;
        return this;
    }

    public CurseSearchQuery gameVersion(CurseGameVersion<?> version) {
        Preconditions.checkNotNull(version, "version should not be null");
        if (this.gameID != 0) {
            Preconditions.checkArgument(version.gameID() == this.gameID, "Game version should match game ID");
        }
        this.gameVersionString(version.versionString());
        return this;
    }

    public CurseSearchQuery clearGameVersionString() {
        this.gameVersion = "";
        return this;
    }

    public int pageIndex() {
        return this.pageIndex;
    }

    public CurseSearchQuery pageIndex(int index) {
        Preconditions.checkArgument(index >= 0, "index should not be smaller than 0");
        this.pageIndex = index;
        return this;
    }

    public CurseSearchQuery clearPageIndex() {
        this.pageIndex = 0;
        return this;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public CurseSearchQuery pageSize(int size) {
        Preconditions.checkArgument(size > 0, "size should be positive");
        this.pageSize = size;
        return this;
    }

    public CurseSearchQuery clearPageSize() {
        this.pageSize = 0;
        return this;
    }

    public String searchFilter() {
        return this.searchFilter;
    }

    public CurseSearchQuery searchFilter(String filter) {
        Preconditions.checkNotNull(filter, "filter should not be null");
        Preconditions.checkArgument(!filter.isEmpty(), "filter should not be empty");
        this.searchFilter = filter;
        return this;
    }

    public CurseSearchQuery clearSearchFilter() {
        this.searchFilter = "";
        return this;
    }

    public CurseSearchSort sortingMethod() {
        return this.sortingMethod;
    }

    public CurseSearchQuery sortingMethod(CurseSearchSort method) {
        Preconditions.checkNotNull(method, "method should not be null");
        this.sortingMethod = method;
        return this;
    }

    public CurseSearchQuery clearSortingMethod() {
        this.sortingMethod = CurseSearchSort.FEATURED;
        return this;
    }
}

