/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.curseapi.file;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.therandomlabs.curseapi.CursePreconditions;
import com.therandomlabs.curseapi.file.BasicCurseFile;
import com.therandomlabs.curseapi.file.CurseFile;
import com.therandomlabs.curseapi.file.CurseReleaseType;
import com.therandomlabs.curseapi.game.CurseGameVersion;
import com.therandomlabs.curseapi.game.CurseGameVersionGroup;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;

public class CurseFileFilter
implements Cloneable,
Predicate<CurseFile> {
    private HashSet<String> gameVersionStrings = new HashSet();
    private int newerThan = 60017;
    private int olderThan = Integer.MAX_VALUE;
    private CurseReleaseType minimumStability = CurseReleaseType.ALPHA;

    public CurseFileFilter clone() {
        try {
            CurseFileFilter filter = (CurseFileFilter)super.clone();
            filter.gameVersionStrings = new HashSet<String>(this.gameVersionStrings);
            return filter;
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public boolean test(CurseFile file) {
        Set<String> gameVersionStrings = this.gameVersionStrings();
        if (!gameVersionStrings.isEmpty() && Collections.disjoint(gameVersionStrings, file.gameVersionStrings())) {
            return false;
        }
        return file.newerThan(this.newerThan()) && file.olderThan(this.olderThan()) && file.releaseType().hasMinimumStability(this.minimumStability());
    }

    public Set<String> gameVersionStrings() {
        return (Set)this.gameVersionStrings.clone();
    }

    public CurseFileFilter gameVersionStrings(String ... versions) {
        Preconditions.checkNotNull(versions, "versions should not be null");
        return this.gameVersionStrings(ImmutableSet.copyOf(versions));
    }

    public CurseFileFilter gameVersionStrings(Collection<String> versions) {
        Preconditions.checkNotNull(versions, "versions should not be null");
        this.gameVersionStrings.addAll(versions);
        return this;
    }

    public CurseFileFilter gameVersionsArray(CurseGameVersion<?> ... versions) {
        Preconditions.checkNotNull(versions, "versions should not be null");
        return this.gameVersions(ImmutableSet.copyOf(versions));
    }

    public CurseFileFilter gameVersions(Collection<? extends CurseGameVersion<?>> versions) {
        Preconditions.checkNotNull(versions, "versions should not be null");
        for (CurseGameVersion<?> version : versions) {
            this.gameVersionStrings(version.versionString());
        }
        return this;
    }

    public CurseFileFilter gameVersionGroupsArray(CurseGameVersionGroup<?> ... versionGroups) {
        Preconditions.checkNotNull(versionGroups, "versionGroups should not be null");
        return this.gameVersionGroups(ImmutableSet.copyOf(versionGroups));
    }

    public CurseFileFilter gameVersionGroups(Collection<? extends CurseGameVersionGroup<?>> versionGroups) {
        Preconditions.checkNotNull(versionGroups, "versionGroups should not be null");
        for (CurseGameVersionGroup<?> versionGroup : versionGroups) {
            this.gameVersions(versionGroup.versions());
        }
        return this;
    }

    public CurseFileFilter clearGameVersions() {
        this.gameVersionStrings.clear();
        return this;
    }

    public int newerThan() {
        return this.newerThan;
    }

    public CurseFileFilter newerThan(BasicCurseFile file) {
        Preconditions.checkNotNull(file, "file should not be null");
        return this.newerThan(file.id());
    }

    public CurseFileFilter newerThan(int fileID) {
        CursePreconditions.checkFileID(fileID, "fileID");
        Preconditions.checkArgument(fileID < this.olderThan, "fileID should be older than the \"older than\" file");
        this.newerThan = fileID;
        return this;
    }

    public CurseFileFilter clearNewerThan() {
        this.newerThan = 60017;
        return this;
    }

    public int olderThan() {
        return this.olderThan;
    }

    public CurseFileFilter olderThan(BasicCurseFile file) {
        Preconditions.checkNotNull(file, "file should not be null");
        return this.olderThan(file.id());
    }

    public CurseFileFilter olderThan(int fileID) {
        CursePreconditions.checkFileID(fileID, "fileID");
        Preconditions.checkArgument(fileID > this.newerThan, "fileID should be newer than the \"newer than\" file");
        this.olderThan = fileID;
        return this;
    }

    public CurseFileFilter clearOlderThan() {
        this.olderThan = Integer.MAX_VALUE;
        return this;
    }

    public CurseFileFilter between(BasicCurseFile olderFile, BasicCurseFile newerFile) {
        Preconditions.checkNotNull(olderFile, "olderFile should not be null");
        Preconditions.checkNotNull(newerFile, "newerFile should not be null");
        return this.between(olderFile.id(), newerFile.id());
    }

    public CurseFileFilter between(int olderFileID, int newerFileID) {
        CursePreconditions.checkFileID(olderFileID, "olderFileID");
        CursePreconditions.checkFileID(newerFileID, "newerFileID");
        Preconditions.checkArgument(newerFileID > olderFileID, "newerFileID should be newer than olderFileID");
        this.newerThan(olderFileID);
        this.olderThan(newerFileID);
        return this;
    }

    public CurseReleaseType minimumStability() {
        return this.minimumStability;
    }

    public CurseFileFilter minimumStability(CurseReleaseType releaseType) {
        Preconditions.checkNotNull(releaseType, "releaseType should not be null");
        this.minimumStability = releaseType;
        return this;
    }

    public CurseFileFilter clearMinimumStability() {
        this.minimumStability = CurseReleaseType.ALPHA;
        return this;
    }

    public boolean apply(Collection<? extends CurseFile> files) {
        return files.removeIf(this.negate());
    }
}

